<?php
session_start();
define('SECURE_INCLUDE', true);

require_once '../../config/db.php';
require_once '../../includes/csrf.php';

// ✅ تحقق من CSRF
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    die('رمز الحماية غير صالح.');
}

$username = trim($_POST['username']);
$password = trim($_POST['password']);

if (empty($username) || empty($password)) {
    die('يرجى ملء جميع الحقول.');
}

$stmt = $pdo->prepare("SELECT * FROM users WHERE name = ?");
$stmt->execute([$username]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user && password_verify($password, $user['password'])) {
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['username'] = $user['name'];
    $_SESSION['role'] = $user['role'];
    header("Location: ../../pages/dashboard.php");
    exit();
} else {
    die('اسم المستخدم أو كلمة المرور غير صحيحة.');
}
