<?php
session_start();
define('SECURE_INCLUDE', true);

require_once '../../config/db.php';

if (trim($_POST['antibot']) !== $_SESSION['antibot_answer']) {
    die('فشل التحقق من الإنسان.');
}

$name = trim($_POST['new_username']);
$email = trim($_POST['email']);
$password_raw = trim($_POST['new_password']);
$password = password_hash($password_raw, PASSWORD_DEFAULT);

$role = 'user';
$gender = 'unknown';
$phone = '';
$avatar = '/assets/images/default_avatar.png';
$created_at = date('Y-m-d H:i:s');

if (empty($name) || empty($email) || empty($password_raw)) {
    die('يرجى ملء جميع الحقول.');
}

$stmt = $pdo->prepare("SELECT id FROM users WHERE name = ? OR email = ?");
$stmt->execute([$name, $email]);

if ($stmt->fetch()) {
    die('اسم المستخدم أو البريد الإلكتروني مستخدم مسبقًا.');
}

$stmt = $pdo->prepare("INSERT INTO users (name, email, password, role, gender, phone, avatar, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->execute([$name, $email, $password, $role, $gender, $phone, $avatar, $created_at]);

$_SESSION['user_id'] = $pdo->lastInsertId();
$_SESSION['username'] = $name;
$_SESSION['role'] = $role;

header("Location: ../../pages/dashboard.php");
exit();
